-- name       : check_users.sql
-- date       : 25-Mar-2002
-- Author     : Pentest Limited
-- Modified	  : 31-Oct-2002
-- By		  : Mark Rowe
-- Fixed	  : Inserted correct hashes for ORACLE, ORAREGSYS, ORDPLUGINS, ORDSYS
-- Description: Check all of the possible default users to see if they still
--              have the default passwords set. 
-- limitation : need to have access to dba_users
-- 
-- useage     : SQL> @check_users

set head off                                                                                                                                                                                            
set lines 79                                                                                                                                                                                            
set pages 0                                                                                                                                                                                             
set feed off
column account_status newline                                                                                                                                                                                            
spool check_users.lis                                                                                                                                                                                   
connect <appropriate user>  
SELECT 'user: ADAMS password is the default (WOOD/72CDEF4A3483F60D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ADAMS' AND password='72CDEF4A3483F60D';
SELECT 'user: ADLDEMO password is the default (ADLDEMO/147215F51929A6E8)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ADLDEMO' AND password='147215F51929A6E8';
SELECT 'user: ADMIN password is the default (JETSPEED/CAC22318F162D597)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ADMIN' AND password='CAC22318F162D597';
SELECT 'user: ADMIN password is the default (WELCOME/B8B15AC9A946886A)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ADMIN' AND password='B8B15AC9A946886A';
SELECT 'user: ADMINISTRATOR password is the default (ADMINISTRATOR/1848F0A31D1C5C62)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ADMINISTRATOR' AND password='1848F0A31D1C5C62';
SELECT 'user: ADMINISTRATOR password is the default (ADMIN/F9ED601D936158BD)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ADMINISTRATOR' AND password='F9ED601D936158BD';
SELECT 'user: ANDY password is the default (SWORDFISH/B8527562E504BC3F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ANDY' AND password='B8527562E504BC3F';
SELECT 'user: AP password is the default (AP/EED09A552944B6AD)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='AP' AND password='EED09A552944B6AD';
SELECT 'user: APPLSYS password is the default (FND/0F886772980B8C79)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='APPLSYS' AND password='0F886772980B8C79';
SELECT 'user: APPLYSYSPUB password is the default (PUB/A5E09E84EC486FC9)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='APPLYSYSPUB' AND password='A5E09E84EC486FC9';
SELECT 'user: APPS password is the default (APPS/D728438E8A5925E0)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='APPS' AND password='D728438E8A5925E0';
SELECT 'user: APPUSER password is the default (APPPASSWORD/7E2C3C2D4BF4071B)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='APPUSER' AND password='7E2C3C2D4BF4071B';
SELECT 'user: AQ password is the default (AQ/2B0C31040A1CFB48)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='AQ' AND password='2B0C31040A1CFB48';
SELECT 'user: AQDEMO password is the default (AQDEMO/5140E342712061DD)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='AQDEMO' AND password='5140E342712061DD';
SELECT 'user: AQJAVA password is the default (AQJAVA/8765D2543274B42E)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='AQJAVA' AND password='8765D2543274B42E';
SELECT 'user: AQUSER password is the default (AQUSER/4CF13BDAC1D7511C)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='AQUSER' AND password='4CF13BDAC1D7511C';
SELECT 'user: AUDIOUSER password is the default (AUDIOUSER/CB4F2CEC5A352488)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='AUDIOUSER' AND password='CB4F2CEC5A352488';
SELECT 'user: AURORA$JIS$UTILITY$ password is the default (INVALID/E1BAE6D95AA95F1E)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='AURORA$JIS$UTILITY$' AND password='E1BAE6D95AA95F1E';
SELECT 'user: AURORA$ORB$UNAUTHENTICATED password is the default (INVALID/80C099F0EADF877E)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='AURORA$ORB$UNAUTHENTICATED' AND password='80C099F0EADF877E';
SELECT 'user: BC4J password is the default (BC4J/EAA333E83BF2810D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='BC4J' AND password='EAA333E83BF2810D';
SELECT 'user: BLAKE password is the default (PAPER/9435F2E60569158E)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='BLAKE' AND password='9435F2E60569158E';
SELECT 'user: BRIO_ADMIN password is the default (BRIO_ADMIN/EB50644BE27DF70B)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='BRIO_ADMIN' AND password='EB50644BE27DF70B';
SELECT 'user: CATALOG password is the default (CATALOG/397129246919E8DA)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CATALOG' AND password='397129246919E8DA';
SELECT 'user: CDEMO82 password is the default (UNKNOWN/67B891F114BE3AEB)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CDEMO82' AND password='67B891F114BE3AEB';
SELECT 'user: CDEMO82 password is the default (CDEMO82/7299A5E2A5A05820)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CDEMO82' AND password='7299A5E2A5A05820';
SELECT 'user: CDEMOCOR password is the default (CDEMOCOR/3A34F0B26B951F3F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CDEMOCOR' AND password='3A34F0B26B951F3F';
SELECT 'user: CDEMORID password is the default (CDEMORID/E39CEFE64B73B308)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CDEMORID' AND password='E39CEFE64B73B308';
SELECT 'user: CDEMOUCB password is the default (CDEMOUCB/CEAE780F25D556F8)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CDEMOUCB' AND password='CEAE780F25D556F8';
SELECT 'user: CENTRA password is the default (CENTRA/63BF5FFE5E3EA16D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CENTRA' AND password='63BF5FFE5E3EA16D';
SELECT 'user: CIDS password is the default (CIDS/AA71234EF06CE6B3)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CIDS' AND password='AA71234EF06CE6B3';
SELECT 'user: CIS password is the default (ZWERG/AA2602921607EE84)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CIS' AND password='AA2602921607EE84';
SELECT 'user: CISINFO password is the default (ZWERG/BEA52A368C31B86F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CISINFO' AND password='BEA52A368C31B86F';
SELECT 'user: CLARK password is the default (CLOTH/7AAFE7D01511D73F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CLARK' AND password='7AAFE7D01511D73F';
SELECT 'user: COMPANY password is the default (COMPANY/402B659C15EAF6CB)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='COMPANY' AND password='402B659C15EAF6CB';
SELECT 'user: COMPIERE password is the default (COMPIERE/E3D0DCF4B4DBE626)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='COMPIERE' AND password='E3D0DCF4B4DBE626';
SELECT 'user: CQSCHEMAUSER password is the default (PASSWORD/04071E7EDEB2F5CC)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CQSCHEMAUSER' AND password='04071E7EDEB2F5CC';
SELECT 'user: CSMIG password is the default (CSMIG/09B4BB013FBD0D65)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CSMIG' AND password='09B4BB013FBD0D65';
SELECT 'user: CTXDEMO password is the default (CTXDEMO/CB6B5E9D9672FE89)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CTXDEMO' AND password='CB6B5E9D9672FE89';
SELECT 'user: CTXSYS password is the default (CTXSYS/24ABAB8B06281B4C)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CTXSYS' AND password='24ABAB8B06281B4C';
SELECT 'user: CTXSYS password is the default (UNKNOWN/71E687F036AD56E5)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='CTXSYS' AND password='71E687F036AD56E5';
SELECT 'user: DBI password is the default (MUMBLEFRATZ/D8FF6ECEF4C50809)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='DBI' AND password='D8FF6ECEF4C50809';
SELECT 'user: DBSNMP password is the default (DBSNMP/E066D214D5421CCC)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='DBSNMP' AND password='E066D214D5421CCC';
SELECT 'user: DEMO password is the default (DEMO/4646116A123897CF)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='DEMO' AND password='4646116A123897CF';
SELECT 'user: DEMO8 password is the default (DEMO8/0E7260738FDFD678)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='DEMO8' AND password='0E7260738FDFD678';
SELECT 'user: DEMO9 password is the default (DEMO9/EE02531A80D998CA)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='DEMO9' AND password='EE02531A80D998CA';
SELECT 'user: DES password is the default (DES/ABFEC5AC2274E54D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='DES' AND password='ABFEC5AC2274E54D';
SELECT 'user: DEV2000_DEMOS password is the default (DEV2000_DEMOS/18A0C8BD6B13BEE2)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='DEV2000_DEMOS' AND password='18A0C8BD6B13BEE2';
SELECT 'user: DISCOVERER_ADMIN password is the default (DISCOVERER_ADMIN/5C1AED4D1AADAA4C)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='DISCOVERER_ADMIN' AND password='5C1AED4D1AADAA4C';
SELECT 'user: DSGATEWAY password is the default (DSGATEWAY/6869F3CFD027983A)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='DSGATEWAY' AND password='6869F3CFD027983A';
SELECT 'user: DSSYS password is the default (DSSYS/E3B6E6006B3A99E0)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='DSSYS' AND password='E3B6E6006B3A99E0';
SELECT 'user: EMP password is the default (EMP/B40C23C6E2B4EA3D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='EMP' AND password='B40C23C6E2B4EA3D';
SELECT 'user: ESTOREUSER password is the default (ESTORE/51063C47AC2628D4)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ESTOREUSER' AND password='51063C47AC2628D4';
SELECT 'user: EVENT password is the default (EVENT/7CA0A42DA768F96D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='EVENT' AND password='7CA0A42DA768F96D';
SELECT 'user: FINANCE password is the default (FINANCE/6CBBF17292A1B9AA)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='FINANCE' AND password='6CBBF17292A1B9AA';
SELECT 'user: FND password is the default (FND/0C0832F8B6897321)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='FND' AND password='0C0832F8B6897321';
SELECT 'user: FROSTY password is the default (SNOWMAN/2ED539F71B4AA697)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='FROSTY' AND password='2ED539F71B4AA697';
SELECT 'user: GL password is the default (GL/CD6E99DACE4EA3A6)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='GL' AND password='CD6E99DACE4EA3A6';
SELECT 'user: GPFD password is the default (GPFD/BA787E988F8BC424)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='GPFD' AND password='BA787E988F8BC424';
SELECT 'user: GPLD password is the default (GPLD/9D561E4D6585824B)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='GPLD' AND password='9D561E4D6585824B';
SELECT 'user: HCPARK password is the default (HCPARK/3DE1EBA32154C56B)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='HCPARK' AND password='3DE1EBA32154C56B';
SELECT 'user: HLW password is the default (HLW/855296220C095810)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='HLW' AND password='855296220C095810';
SELECT 'user: HR password is the default (HR/4C6D73C3E8B0F0DA)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='HR' AND password='4C6D73C3E8B0F0DA';
SELECT 'user: HR password is the default (UNKNOWN/6399F3B38EDF3288)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='HR' AND password='6399F3B38EDF3288';
SELECT 'user: IMAGEUSER password is the default (IMAGEUSER/E079BF5E433F0B89)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='IMAGEUSER' AND password='E079BF5E433F0B89';
SELECT 'user: IMEDIA password is the default (IMEDIA/8FB1DC9A6F8CE827)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='IMEDIA' AND password='8FB1DC9A6F8CE827';
SELECT 'user: JMUSER password is the default (JMUSER/063BA85BF749DF8E)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='JMUSER' AND password='063BA85BF749DF8E';
SELECT 'user: JONES password is the default (STEEL/B9E99443032F059D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='JONES' AND password='B9E99443032F059D';
SELECT 'user: JWARD password is the default (AIROPLANE/CF9CB787BD98DA7F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='JWARD' AND password='CF9CB787BD98DA7F';
SELECT 'user: L2LDEMO password is the default (L2LDEMO/0A6B2DF907484CEE)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='L2LDEMO' AND password='0A6B2DF907484CEE';
SELECT 'user: LBACSYS password is the default (LBACSYS/AC9700FD3F1410EB)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='LBACSYS' AND password='AC9700FD3F1410EB';
SELECT 'user: LIBRARIAN password is the default (SHELVES/11E0654A7068559C)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='LIBRARIAN' AND password='11E0654A7068559C';
SELECT 'user: MASTER password is the default (PASSWORD/9C4F452058285A74)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MASTER' AND password='9C4F452058285A74';
SELECT 'user: MDDEMO password is the default (MDDEMO/46DFFB4D08C33739)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MDDEMO' AND password='46DFFB4D08C33739';
SELECT 'user: MDDEMO_CLERK password is the default (CLERK/564F871D61369A39)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MDDEMO_CLERK' AND password='564F871D61369A39';
SELECT 'user: MDDEMO_MGR password is the default (MGR/B41BCD9D3737F5C4)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MDDEMO_MGR' AND password='B41BCD9D3737F5C4';
SELECT 'user: MDSYS password is the default (MDSYS/72979A94BAD2AF80)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MDSYS' AND password='72979A94BAD2AF80';
SELECT 'user: MFG password is the default (MFG/FC1B0DD35E790847)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MFG' AND password='FC1B0DD35E790847';
SELECT 'user: MGWUSER password is the default (MGWUSER/EA514DD74D7DE14C)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MGWUSER' AND password='EA514DD74D7DE14C';
SELECT 'user: MIGRATE password is the default (MIGRATE/5A88CE52084E9700)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MIGRATE' AND password='5A88CE52084E9700';
SELECT 'user: MILLER password is the default (MILLER/D0EFCD03C95DF106)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MILLER' AND password='D0EFCD03C95DF106';
SELECT 'user: MMO2 password is the default (MMO2/AE128772645F6709)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MMO2' AND password='AE128772645F6709';
SELECT 'user: MMO2 password is the default (UNKNOWN/A0E2085176E05C85)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MMO2' AND password='A0E2085176E05C85';
SELECT 'user: MODTEST password is the default (YES/BBFF58334CDEF86D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MODTEST' AND password='BBFF58334CDEF86D';
SELECT 'user: MOREAU password is the default (MOREAU/CF5A081E7585936B)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MOREAU' AND password='CF5A081E7585936B';
SELECT 'user: MTS_USER password is the default (MTS_PASSWORD/E462DB4671A51CD4)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MTS_USER' AND password='E462DB4671A51CD4';
SELECT 'user: MTSSYS password is the default (MTSSYS/6465913FF5FF1831)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MTSSYS' AND password='6465913FF5FF1831';
SELECT 'user: MXAGENT password is the default (MXAGENT/C5F0512A64EB0E7F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='MXAGENT' AND password='C5F0512A64EB0E7F';
SELECT 'user: NAMES password is the default (NAMES/9B95D28A979CC5C4)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='NAMES' AND password='9B95D28A979CC5C4';
SELECT 'user: OAS_PUBLIC password is the default (OAS_PUBLIC/A8116DB6E84FA95D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OAS_PUBLIC' AND password='A8116DB6E84FA95D';
SELECT 'user: OCITEST password is the default (OCITEST/C09011CB0205B347)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OCITEST' AND password='C09011CB0205B347';
SELECT 'user: ODS password is the default (ODS/89804494ADFC71BC)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ODS' AND password='89804494ADFC71BC';
SELECT 'user: ODSCOMMON password is the default (ODSCOMMON/59BBED977430C1A8)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ODSCOMMON' AND password='59BBED977430C1A8';
SELECT 'user: ODM password is the default (ODM/C252E8FA117AF049)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ODM' AND password='C252E8FA117AF049';
SELECT 'user: ODM_MTR password is the default (MTRPW/A7A32CD03D3CE8D5)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ODM_MTR' AND password='A7A32CD03D3CE8D5';
SELECT 'user: OE password is the default (OE/D1A2DFC623FDA40A)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OE' AND password='D1A2DFC623FDA40A';
SELECT 'user: OE password is the default (UNKNOWN/9C30855E7E0CB02D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OE' AND password='9C30855E7E0CB02D';
SELECT 'user: OEMADM password is the default (OEMADM/9DCE98CCF541AAE6)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OEMADM' AND password='9DCE98CCF541AAE6';
SELECT 'user: OEMREP password is the default (OEMREP/7BB2F629772BF2E5)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OEMREP' AND password='7BB2F629772BF2E5';
SELECT 'user: OLAPDBA password is the default (OLAPDBA/1AF71599EDACFB00)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OLAPDBA' AND password='1AF71599EDACFB00';
SELECT 'user: OLAPSVR password is the default (INSTANCE/AF52CFD036E8F425)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OLAPSVR' AND password='AF52CFD036E8F425';
SELECT 'user: OLAPSYS password is the default (MANAGER/3FB8EF9DB538647C)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OLAPSYS' AND password='3FB8EF9DB538647C';
SELECT 'user: OMWB_EMULATION password is the default (ORACLE/54A85D2A0AB8D865)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OMWB_EMULATION' AND password='54A85D2A0AB8D865';
SELECT 'user: OO password is the default (OO/2AB9032E4483FAFC)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OO' AND password='2AB9032E4483FAFC';
SELECT 'user: OPENSPIRIT password is the default (OPENSPIRIT/D664AAB21CE86FD2)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OPENSPIRIT' AND password='D664AAB21CE86FD2';
SELECT 'user: ORACACHE password is the default (ORACACHE/5A4EEC421DE68DDD)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ORACACHE' AND password='5A4EEC421DE68DDD';
SELECT 'user: ORAREGSYS password is the default (ORAREGSYS/28D778112C63CB15)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ORAREGSYS' AND password='28D778112C63CB15';
SELECT 'user: ORDPLUGINS password is the default (ORDPLUGINS/88A2B2C183431F00)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ORDPLUGINS' AND password='88A2B2C183431F00';
SELECT 'user: ORDSYS password is the default (ORDSYS/7EFA02EC7EA6B86F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ORDSYS' AND password='7EFA02EC7EA6B86F';
SELECT 'user: ORACLE password is the default (ORACLE/38E38619A12E0257)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ORACLE' AND password='38E38619A12E0257';
SELECT 'user: ORASSO password is the default (ORASSO/F3701A008AA578CF)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ORASSO' AND password='F3701A008AA578CF';
SELECT 'user: OSE$HTTP$ADMIN password is the default (INVALID/05327CD9F6114E21)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OSE$HTTP$ADMIN' AND password='05327CD9F6114E21';
SELECT 'user: OSP22 password is the default (OSP22/C04057049DF974C2)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OSP22' AND password='C04057049DF974C2';
SELECT 'user: OUTLN password is the default (OUTLN/4A3BA55E08595C81)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OUTLN' AND password='4A3BA55E08595C81';
SELECT 'user: OWA password is the default (OWA/CA5D67CD878AFC49)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OWA' AND password='CA5D67CD878AFC49';
SELECT 'user: OWA_PUBLIC password is the default (OWA_PUBLIC/0D9EC1D1F2A37657)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OWA_PUBLIC' AND password='0D9EC1D1F2A37657';
SELECT 'user: OWNER password is the default (OWNER/5C3546B4F9165300)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='OWNER' AND password='5C3546B4F9165300';
SELECT 'user: PANAMA password is the default (PANAMA/3E7B4116043BEAFF)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PANAMA' AND password='3E7B4116043BEAFF';
SELECT 'user: PATROL password is the default (PATROL/0478B8F047DECC65)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PATROL' AND password='0478B8F047DECC65';
SELECT 'user: PERFSTAT password is the default (PERFSTAT/AC98877DE1297365)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PERFSTAT' AND password='AC98877DE1297365';
SELECT 'user: PLEX password is the default (PLEX/99355BF0E53FF635)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PLEX' AND password='99355BF0E53FF635';
SELECT 'user: PLSQL password is the default (SUPERSECRET/C4522E109BCF69D0)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PLSQL' AND password='C4522E109BCF69D0';
SELECT 'user: PM password is the default (PM/C7A235E6D2AF6018)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PM' AND password='C7A235E6D2AF6018';
SELECT 'user: PM password is the default (UNKNOWN/72E382A52E89575A)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PM' AND password='72E382A52E89575A';
SELECT 'user: PO password is the default (PO/355CBEC355C10FEF)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PO' AND password='355CBEC355C10FEF';
SELECT 'user: PO7 password is the default (PO7/6B870AF28F711204)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PO7' AND password='6B870AF28F711204';
SELECT 'user: PO8 password is the default (PO8/7E15FBACA7CDEBEC)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PO8' AND password='7E15FBACA7CDEBEC';
SELECT 'user: PORTAL30 password is the default (PORTAL31/D373ABE86992BE68)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PORTAL30' AND password='D373ABE86992BE68';
SELECT 'user: PORTAL30 password is the default (PORTAL30/969F9C3839672C6D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PORTAL30' AND password='969F9C3839672C6D';
SELECT 'user: PORTAL30_DEMO password is the default (PORTAL30_DEMO/CFD1302A7F832068)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PORTAL30_DEMO' AND password='CFD1302A7F832068';
SELECT 'user: PORTAL30_PUBLIC password is the default (PORTAL30_PUBLIC/42068201613CA6E2)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PORTAL30_PUBLIC' AND password='42068201613CA6E2';
SELECT 'user: PORTAL30_SSO password is the default (PORTAL30_SSO/882B80B587FCDBC8)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PORTAL30_SSO' AND password='882B80B587FCDBC8';
SELECT 'user: PORTAL30_SSO_PS password is the default (PORTAL30_SSO_PS/F2C3DC8003BC90F8)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PORTAL30_SSO_PS' AND password='F2C3DC8003BC90F8';
SELECT 'user: PORTAL30_SSO_PUBLIC password is the default (PORTAL30_SSO_PUBLIC/98741BDA2AC7FFB2)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PORTAL30_SSO_PUBLIC' AND password='98741BDA2AC7FFB2';
SELECT 'user: POWERCARTUSER password is the default (POWERCARTUSER/2C5ECE3BEC35CE69)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='POWERCARTUSER' AND password='2C5ECE3BEC35CE69';
SELECT 'user: PRIMARY password is the default (PRIMARY/70C3248DFFB90152)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PRIMARY' AND password='70C3248DFFB90152';
SELECT 'user: PUBSUB password is the default (PUBSUB/80294AE45A46E77B)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PUBSUB' AND password='80294AE45A46E77B';
SELECT 'user: PUBSUB1 password is the default (PUBSUB1/D6DF5BBC8B64933E)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='PUBSUB1' AND password='D6DF5BBC8B64933E';
SELECT 'user: QDBA password is the default (QDBA/AE62CB8167819595)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QDBA' AND password='AE62CB8167819595';
SELECT 'user: QS password is the default (QS/4603BCD2744BDE4F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS' AND password='4603BCD2744BDE4F';
SELECT 'user: QS password is the default (UNKNOWN/8B09C6075BDF2DC4)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS' AND password='8B09C6075BDF2DC4';
SELECT 'user: QS_ADM password is the default (QS_ADM/3990FB418162F2A0)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_ADM' AND password='3990FB418162F2A0';
SELECT 'user: QS_ADM password is the default (UNKNOWN/991CDDAD5C5C32CA)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_ADM' AND password='991CDDAD5C5C32CA';
SELECT 'user: QS_CB password is the default (QS_CB/870C36D8E6CD7CF5)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_CB' AND password='870C36D8E6CD7CF5';
SELECT 'user: QS_CB password is the default (UNKNOWN/991CDDAD5C5C32CA)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_CB' AND password='991CDDAD5C5C32CA';
SELECT 'user: QS_CBADM password is the default (QS_CBADM/20E788F9D4F1D92C)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_CBADM' AND password='20E788F9D4F1D92C';
SELECT 'user: QS_CBADM password is the default (UNKNOWN/7C632AFB71F8D305)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_CBADM' AND password='7C632AFB71F8D305';
SELECT 'user: QS_CS password is the default (QS_CS/2CA6D0FC25128CF3)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_CS' AND password='2CA6D0FC25128CF3';
SELECT 'user: QS_CS password is the default (UNKNOWN/91A00922D8C0F146)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_CS' AND password='91A00922D8C0F146';
SELECT 'user: QS_ES password is the default (QS_ES/9A5F2D9F5D1A9EF4)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_ES' AND password='9A5F2D9F5D1A9EF4';
SELECT 'user: QS_ES password is the default (UNKNOWN/E6A6FA4BB042E3C2)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_ES' AND password='E6A6FA4BB042E3C2';
SELECT 'user: QS_OS password is the default (QS_OS/0EF5997DC2638A61)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_OS' AND password='0EF5997DC2638A61';
SELECT 'user: QS_OS password is the default (UNKNOWN/FF09F3EB14AE5C26)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_OS' AND password='FF09F3EB14AE5C26';
SELECT 'user: QS_WS password is the default (QS_WS/0447F2F756B4F460)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_WS' AND password='0447F2F756B4F460';
SELECT 'user: QS_WS password is the default (UNKNOWN/24ACF617DD7D8F2F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='QS_WS' AND password='24ACF617DD7D8F2F';
SELECT 'user: RE password is the default (RE/933B9A9475E882A6)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='RE' AND password='933B9A9475E882A6';
SELECT 'user: REP_MANAGER password is the default (DEMO/2D4B13A8416073A1)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='REP_MANAGER' AND password='2D4B13A8416073A1';
SELECT 'user: REP_OWNER password is the default (DEMO/88D8F06915B1FE30)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='REP_OWNER' AND password='88D8F06915B1FE30';
SELECT 'user: REP_OWNER password is the default (REP_OWNER/BD99EC2DD84E3B5C)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='REP_OWNER' AND password='BD99EC2DD84E3B5C';
SELECT 'user: REPADMIN password is the default (REPADMIN/915C93F34954F5F8)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='REPADMIN' AND password='915C93F34954F5F8';
SELECT 'user: REPORTS_USER password is the default (OEM_TEMP/635074B4416CD3AC)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='REPORTS_USER' AND password='635074B4416CD3AC';
SELECT 'user: RMAIL password is the default (RMAIL/DA4435BBF8CAE54C)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='RMAIL' AND password='DA4435BBF8CAE54C';
SELECT 'user: RMAN password is the default (RMAN/E7B5D92911C831E1)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='RMAN' AND password='E7B5D92911C831E1';
SELECT 'user: SAMPLE password is the default (SAMPLE/E74B15A3F7A19CA8)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SAMPLE' AND password='E74B15A3F7A19CA8';
SELECT 'user: SAP password is the default (SAPR3/BEAA1036A464F9F0)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SAP' AND password='BEAA1036A464F9F0';
SELECT 'user: SCOTT password is the default (TIGER/F894844C34402B67)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SCOTT' AND password='F894844C34402B67';
SELECT 'user: SDOS_ICSAP password is the default (SDOS_ICSAP/C789210ACC24DA16)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SDOS_ICSAP' AND password='C789210ACC24DA16';
SELECT 'user: SECDEMO password is the default (SECDEMO/009BBE8142502E10)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SECDEMO' AND password='009BBE8142502E10';
SELECT 'user: SERVICECONSUMER1 password is the default (SERVICECONSUMER1/183AC2094A6BD59F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SERVICECONSUMER1' AND password='183AC2094A6BD59F';
SELECT 'user: SH password is the default (SH/54B253CBBAAA8C48)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SH' AND password='54B253CBBAAA8C48';
SELECT 'user: SH password is the default (UNKNOWN/9793B3777CD3BD1A)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SH' AND password='9793B3777CD3BD1A';
SELECT 'user: SITEMINDER password is the default (SITEMINDER/061354246A45BBAB)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SITEMINDER' AND password='061354246A45BBAB';
SELECT 'user: SLIDE password is the default (SLIDEPW/FDFE8B904875643D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SLIDE' AND password='FDFE8B904875643D';
SELECT 'user: STARTER password is the default (STARTER/6658C384B8D63B0A)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='STARTER' AND password='6658C384B8D63B0A';
SELECT 'user: STRAT_USER password is the default (STRAT_PASSWD/AEBEDBB4EFB5225B)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='STRAT_USER' AND password='AEBEDBB4EFB5225B';
SELECT 'user: SWPRO password is the default (SWPRO/4CB05AA42D8E3A47)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SWPRO' AND password='4CB05AA42D8E3A47';
SELECT 'user: SWUSER password is the default (SWUSER/783E58C29D2FC7E1)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SWUSER' AND password='783E58C29D2FC7E1';
SELECT 'user: SYMPA password is the default (SYMPA/E7683741B91AF226)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SYMPA' AND password='E7683741B91AF226';
SELECT 'user: SYS password is the default (CHANGE_ON_INSTALL/D4C5016086B2DC6A)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SYS' AND password='D4C5016086B2DC6A';
SELECT 'user: SYS password is the default (D_SYSPW/43BE121A2A135FF3)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SYS' AND password='43BE121A2A135FF3';
SELECT 'user: SYSADM password is the default (SYSADM/BA3E855E93B5B9B0)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SYSADM' AND password='BA3E855E93B5B9B0';
SELECT 'user: SYSMAN password is the default (OEM_TEMP/639C32A115D2CA57)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SYSMAN' AND password='639C32A115D2CA57';
SELECT 'user: SYSTEM password is the default (MANAGER/D4DF7931AB130E37)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SYSTEM' AND password='D4DF7931AB130E37';
SELECT 'user: SYSTEM password is the default (D_SYSTPW/4438308EE0CAFB7F)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='SYSTEM' AND password='4438308EE0CAFB7F';
SELECT 'user: TAHITI password is the default (TAHITI/F339612C73D27861)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='TAHITI' AND password='F339612C73D27861';
SELECT 'user: TDOS_ICSAP password is the default (TDOS_ICSAP/7C0900F751723768)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='TDOS_ICSAP' AND password='7C0900F751723768';
SELECT 'user: TESTPILOT password is the default (TESTPILOT/DE5B73C964C7B67D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='TESTPILOT' AND password='DE5B73C964C7B67D';
SELECT 'user: TRACESVR password is the default (TRACE/F9DA8977092B7B81)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='TRACESVR' AND password='F9DA8977092B7B81';
SELECT 'user: TRAVEL password is the default (TRAVEL/97FD0AE6DFF0F5FE)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='TRAVEL' AND password='97FD0AE6DFF0F5FE';
SELECT 'user: TSDEV password is the default (TSDEV/29268859446F5A8C)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='TSDEV' AND password='29268859446F5A8C';
SELECT 'user: TSUSER password is the default (TSUSER/90C4F894E2972F08)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='TSUSER' AND password='90C4F894E2972F08';
SELECT 'user: TURBINE password is the default (TURBINE/76F373437F33F347)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='TURBINE' AND password='76F373437F33F347';
SELECT 'user: ULTIMATE password is the default (ULTIMATE/4C3F880EFA364016)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='ULTIMATE' AND password='4C3F880EFA364016';
SELECT 'user: USER password is the default (USER/74085BE8A9CF16B4)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER' AND password='74085BE8A9CF16B4';
SELECT 'user: USER0 password is the default (USER0/8A0760E2710AB0B4)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER0' AND password='8A0760E2710AB0B4';
SELECT 'user: USER1 password is the default (USER1/BBE7786A584F9103)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER1' AND password='BBE7786A584F9103';
SELECT 'user: USER2 password is the default (USER2/1718E5DBB8F89784)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER2' AND password='1718E5DBB8F89784';
SELECT 'user: USER3 password is the default (USER3/94152F9F5B35B103)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER3' AND password='94152F9F5B35B103';
SELECT 'user: USER4 password is the default (USER4/2907B1BFA9DA5091)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER4' AND password='2907B1BFA9DA5091';
SELECT 'user: USER5 password is the default (USER5/6E97FCEA92BAA4CB)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER5' AND password='6E97FCEA92BAA4CB';
SELECT 'user: USER6 password is the default (USER6/F73E1A76B1E57F3D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER6' AND password='F73E1A76B1E57F3D';
SELECT 'user: USER7 password is the default (USER7/3E9C94488C1A3908)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER7' AND password='3E9C94488C1A3908';
SELECT 'user: USER8 password is the default (USER8/D148049C2780B869)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER8' AND password='D148049C2780B869';
SELECT 'user: USER9 password is the default (USER9/0487AFEE55ECEE66)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='USER9' AND password='0487AFEE55ECEE66';
SELECT 'user: UTLBSTATU password is the default (UTLESTAT/C42D1FA3231AB025)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='UTLBSTATU' AND password='C42D1FA3231AB025';
SELECT 'user: VIDEOUSER password is the default (VIDEOUSER/29ECA1F239B0F7DF)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='VIDEOUSER' AND password='29ECA1F239B0F7DF';
SELECT 'user: VIF_DEVELOPER password is the default (VIF_DEV_PWD/9A7DCB0C1D84C488)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='VIF_DEVELOPER' AND password='9A7DCB0C1D84C488';
SELECT 'user: VIRUSER password is the default (VIRUSER/404B03707BF5CEA3)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='VIRUSER' AND password='404B03707BF5CEA3';
SELECT 'user: VRR1 password is the default (VRR1/811C49394C921D66)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='VRR1' AND password='811C49394C921D66';
SELECT 'user: VRR1 password is the default (UNKNOWN/3D703795F61E3A9A)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='VRR1' AND password='3D703795F61E3A9A';
SELECT 'user: WEBCAL01 password is the default (WEBCAL01/C69573E9DEC14D50)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='WEBCAL01' AND password='C69573E9DEC14D50';
SELECT 'user: WEBDB password is the default (WEBDB/D4C4DCDD41B05A5D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='WEBDB' AND password='D4C4DCDD41B05A5D';
SELECT 'user: WEBREAD password is the default (WEBREAD/F8841A7B16302DE6)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='WEBREAD' AND password='F8841A7B16302DE6';
SELECT 'user: WKPROXY password is the default (UNKNOWN/B97545C4DD2ABE54)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='WKPROXY' AND password='B97545C4DD2ABE54';
SELECT 'user: WKSYS password is the default (WKSYS/545E13456B7DDEA0)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='WKSYS' AND password='545E13456B7DDEA0';
SELECT 'user: WKSYS password is the default (UNKNOWN/69ED49EE1851900D)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='WKSYS' AND password='69ED49EE1851900D';
SELECT 'user: WMSYS password is the default (WMSYS/7C9BA362F8314299)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='WMSYS' AND password='7C9BA362F8314299';
SELECT 'user: WWW password is the default (WWW/6DE993A60BC8DBBF)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='WWW' AND password='6DE993A60BC8DBBF';
SELECT 'user: WWWUSER password is the default (WWWUSER/F239A50072154BAC)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='WWWUSER' AND password='F239A50072154BAC';
SELECT 'user: XDB password is the default (UNKNOWN/88D8364765FCE6AF)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='XDB' AND password='88D8364765FCE6AF';
SELECT 'user: XPRT password is the default (XPRT/0D5C9EFC2DFE52BA)' "default password", 'account status: ' || account_status FROM dba_users WHERE username='XPRT' AND password='0D5C9EFC2DFE52BA';
set feed on                                                                                                                                                                                             
set head on                                                                                                                                                                                             
set termout on                                                                                                                                                                                          
set lines 80                                                                                                                                                                                            
spool off                                                                                                                                                                                               
exit                                                                                                                                                                                      
